# Index - Documentation Technique FoundryVTT v13

**Documentation technique complète pour développer un système FoundryVTT v13**  
**Basée sur l'analyse du système dnd5e 5.2.0**

---

## Vue d'ensemble

Cette section technique couvre l'architecture et les concepts fondamentaux pour développer un système FoundryVTT v13 de qualité professionnelle. Elle s'adresse aux développeurs souhaitant comprendre les rouages internes de Foundry et implémenter leurs propres systèmes.

---

## Documents Disponibles

### 00. Architecture d'un Système
📄 **[00-overview.md](./00-overview.md)** (~250 lignes)

Vue d'ensemble de l'architecture d'un système FoundryVTT :
- Arborescence type des fichiers
- Rôle des différents dossiers (`module/`, `templates/`, `packs/`)
- Cycle de vie du système (hooks init → ready)
- Flux de données (system.json → DataModel → Document)

> **Lecture recommandée** : En premier, pour comprendre la structure globale.

---

### 01. Manifeste system.json
📄 **[01-system-json.md](./01-system-json.md)** (~480 lignes)

Guide complet du fichier manifeste :
- Champs obligatoires et optionnels
- Section `documentTypes` (déclaration des types Actor, Item)
- Section `packs` (compendiums)
- Organisation des packs avec `packFolders`
- Configuration de la grille, tokens, socket
- Exemple de manifeste minimal

> **Lecture recommandée** : Avant de créer votre `system.json`.

---

### 02. DataModels et TypeDataModel
📄 **[02-datamodels.md](./02-datamodels.md)** (~600 lignes)

Documentation complète sur les schémas de données :
- Hiérarchie des classes (`DataModel`, `TypeDataModel`)
- Définition de schémas avec `defineSchema()`
- Types de champs disponibles (`StringField`, `NumberField`, `SchemaField`...)
- Système de templates (mixins)
- Champs personnalisés (`FormulaField`, `MappingField`)
- Validation et migration des données
- Méthodes de préparation (`prepareBaseData`, `prepareDerivedData`)

> **Lecture recommandée** : Essentiel pour définir vos modèles de données.

---

### 03. Documents et Extensions
📄 **[03-documents.md](./03-documents.md)** (~820 lignes)

Guide pour étendre les Documents Foundry :
- Hiérarchie des Documents (`Actor`, `Item`, `ActiveEffect`...)
- Cycle de vie complet (`_preCreate` → `_onCreate` → `prepareData`...)
- Extension de `Actor` avec exemples de dnd5e
- Extension de `Item` (propriétés, utilisation, jets)
- Extension de `ActiveEffect` (concentration, suppression)
- Extension de `ChatMessage` et `Combat`
- Pattern de mixin pour le code partagé
- Enregistrement des extensions dans CONFIG

> **Lecture recommandée** : Pour implémenter la logique métier de votre système.

---

### 04. Applications et Sheets
📄 **[04-applications-sheets.md](./04-applications-sheets.md)** (~1070 lignes)

Documentation complète sur ApplicationV2 :
- Comparaison Application v1 vs ApplicationV2
- Structure et options (`DEFAULT_OPTIONS`, `PARTS`)
- Cycle de vie du rendu (`_prepareContext`, `_onRender`)
- Système de PARTS pour le rendu modulaire
- Système d'actions déclaratif (`data-action`)
- DocumentSheetV2 et binding automatique
- ActorSheetV2 et ItemSheetV2
- Composants UI personnalisés (Custom Elements)
- Enregistrement des sheets
- Patterns avancés (mixins, drag & drop)

> **Lecture recommandée** : Pour créer vos interfaces utilisateur modernes.

---

### 05. Système de Hooks
📄 **[05-hooks.md](./05-hooks.md)** (~970 lignes)

Guide complet sur le système d'événements :
- API des hooks (`Hooks.on`, `Hooks.once`, `Hooks.call`, `Hooks.callAll`)
- Différence entre `call` (bloquant) et `callAll` (informatif)
- Hooks du cycle de vie (`init`, `i18nInit`, `setup`, `ready`)
- Hooks de Documents (CRUD : `preCreate`, `create`, `preUpdate`...)
- Hooks de rendu (`render*`)
- Hooks personnalisés dnd5e (jets, repos, dégâts, combat...)
- Création de hooks personnalisés avec bonnes pratiques
- Debugging des hooks

> **Lecture recommandée** : Pour comprendre comment intercepter et réagir aux événements.

---

### 06. Système de Dés
📄 **[06-dice.md](./06-dice.md)** (~970 lignes)

Documentation sur les jets de dés personnalisés :
- Classe `Roll` de base (création, évaluation, message)
- Syntaxe des formules (variables, modificateurs)
- Types de termes (`DiceTerm`, `NumericTerm`...)
- Classes personnalisées dnd5e (`BasicRoll`, `D20Roll`, `DamageRoll`)
- `D20Die` avec avantage/désavantage
- Configuration des critiques
- Boîtes de dialogue de configuration
- Hooks du système de dés
- Intégration avec les messages de chat
- Exemples complets (compétence, attaque, dégâts)

> **Lecture recommandée** : Pour implémenter votre mécanique de jets.

---

### 07. Templates Handlebars
📄 **[07-templates.md](./07-templates.md)** (~350 lignes)

Documentation complète sur le moteur de rendu Handlebars :
- Syntaxe de base (expressions, échappement HTML)
- Conditions (`{{#if}}`, `{{#unless}}`, opérateurs de comparaison Foundry)
- Boucles (`{{#each}}`) et variables spéciales
- Helpers Foundry natifs (localisation, formulaires, formatage)
- Partials (templates réutilisables)
- Helpers personnalisés
- Organisation des templates et système PARTS (ApplicationV2)
- Bonnes pratiques (performance, sécurité, maintenabilité)
- Débogage des templates

> **Lecture recommandée** : Essentiel pour créer les vues HTML de vos interfaces.

---

### 08. Canvas et Interactions Visuelles
📄 **[08-canvas.md](./08-canvas.md)** (~1115 lignes)

Guide pour étendre le canvas graphique :
- Architecture du canvas (layers, placeables)
- Relation Document / Placeable
- `Token5e` : barre de PV personnalisée, mouvement, anneaux
- `TokenLayer5e` : blocage de mouvement, terrain difficile
- `AbilityTemplate` : templates pour sorts et zones d'effet
- Detection Modes (blindsight, tremorsense...)
- `TokenPlacement` : placement interactif de tokens
- `TokenRuler5e` : règle de mouvement avec couleurs de vitesse
- Icônes de notes personnalisées
- Bonnes pratiques (héritage, hooks, throttling, nettoyage)

> **Lecture recommandée** : Pour personnaliser l'expérience visuelle sur la carte.

---

## Parcours de Lecture Recommandé

### Pour Débutants

1. **[00-overview.md](./00-overview.md)** - Comprendre l'architecture globale
2. **[01-system-json.md](./01-system-json.md)** - Créer votre manifeste
3. **[02-datamodels.md](./02-datamodels.md)** - Définir vos modèles de données
4. **[03-documents.md](./03-documents.md)** - Ajouter la logique métier
5. **[04-applications-sheets.md](./04-applications-sheets.md)** - Créer les interfaces

### Pour Développeurs Intermédiaires

1. **[05-hooks.md](./05-hooks.md)** - Maîtriser le système d'événements
2. **[06-dice.md](./06-dice.md)** - Personnaliser les jets de dés

### Pour Développeurs Avancés

1. **[07-templates.md](./07-templates.md)** - Maîtriser les templates Handlebars
2. **[08-canvas.md](./08-canvas.md)** - Étendre le canvas graphique

---

## Structure de la Documentation

```
docs/tech/
├── index.md                    # ← Ce fichier
├── 00-overview.md              # Architecture générale
├── 01-system-json.md           # Manifeste du système
├── 02-datamodels.md            # Schémas de données
├── 03-documents.md             # Documents et extensions
├── 04-applications-sheets.md   # Interfaces utilisateur
├── 05-hooks.md                 # Système d'événements
├── 06-dice.md                  # Système de dés
├── 07-templates.md             # Templates Handlebars
└── 08-canvas.md                # Canvas et visuels
```

---

## Statistiques

| Document | Lignes | Concepts Clés |
|----------|--------|---------------|
| 00-overview.md | ~250 | Architecture, cycle de vie |
| 01-system-json.md | ~480 | Manifeste, documentTypes, packs |
| 02-datamodels.md | ~600 | Schémas, validation, migration |
| 03-documents.md | ~820 | Actor, Item, hooks de cycle de vie |
| 04-applications-sheets.md | ~1070 | ApplicationV2, PARTS, actions |
| 05-hooks.md | ~970 | Événements, hooks personnalisés |
| 06-dice.md | ~970 | Roll, D20Roll, DamageRoll |
| 07-templates.md | ~350 | Handlebars, partials, helpers |
| 08-canvas.md | ~1115 | Token, Template, Canvas |
| **Total** | **~6625** | |

---

## Liens Complémentaires

### Documentation Règles et Processus
- [../rules/index.md](../rules/index.md) - Bonnes pratiques et anti-patterns

### Ressources Externes
- [API FoundryVTT v13](https://foundryvtt.com/api/)
- [Discord Foundry - Canal Development](https://discord.gg/foundryvtt)
- [GitHub dnd5e](https://github.com/foundryvtt/dnd5e)
- [System Development Wiki](https://foundryvtt.wiki/en/development/guides/SD-tutorial/SD01-Getting-started)

---

*Dernière mise à jour : 2026-01-05*
