# Guide Complet du Manifeste system.json

> Documentation technique pour FoundryVTT v13

## Vue d'ensemble

Le fichier `system.json` est le **manifeste** de votre système. C'est le premier fichier lu par FoundryVTT lors du chargement. Il définit :

- Les métadonnées du système (nom, version, auteurs)
- Les fichiers à charger (scripts, styles)
- Les types de documents supportés (Actor, Item, etc.)
- Les compendiums inclus
- La compatibilité avec les versions de FoundryVTT

## Structure Complète

### Exemple Annoté (basé sur dnd5e v5.2.0)

```json
{
  // ═══════════════════════════════════════════════════════════════
  // MÉTADONNÉES DE BASE
  // ═══════════════════════════════════════════════════════════════
  
  "id": "dnd5e",                    // Identifiant unique (obligatoire)
  "title": "Dungeons & Dragons Fifth Edition",  // Nom affiché
  "description": "A system for playing...",     // Description
  "version": "5.2.0",               // Version SemVer (obligatoire)
  
  // ═══════════════════════════════════════════════════════════════
  // URLS ET DISTRIBUTION
  // ═══════════════════════════════════════════════════════════════
  
  "url": "https://github.com/foundryvtt/dnd5e/",
  "manifest": "https://raw.githubusercontent.com/.../system.json",
  "download": "https://github.com/.../dnd5e-release-5.2.0.zip",
  
  // ═══════════════════════════════════════════════════════════════
  // AUTEURS
  // ═══════════════════════════════════════════════════════════════
  
  "authors": [
    {
      "name": "Atropos",
      "url": "https://foundryvtt.com",
      "flags": {}
    }
  ],
  
  // ═══════════════════════════════════════════════════════════════
  // FICHIERS À CHARGER
  // ═══════════════════════════════════════════════════════════════
  
  "esmodules": [
    "dnd5e.mjs"                     // Point(s) d'entrée ES Module
  ],
  "styles": [
    "dnd5e.css"                     // Feuilles de style
  ],
  
  // ═══════════════════════════════════════════════════════════════
  // COMPATIBILITÉ API
  // ═══════════════════════════════════════════════════════════════
  
  "compatibility": {
    "minimum": "13.347",            // Version minimale requise
    "verified": "13"                // Version testée/vérifiée
  },

  // ... (voir sections détaillées ci-dessous)
}
```

## Champs Obligatoires

| Champ | Type | Description |
|-------|------|-------------|
| `id` | `string` | Identifiant unique du système. Doit correspondre au nom du dossier. Caractères autorisés : `a-z`, `0-9`, `-`. |
| `title` | `string` | Nom affiché dans l'interface Foundry |
| `version` | `string` | Version au format SemVer (ex: `1.0.0`) |
| `compatibility` | `object` | Versions de FoundryVTT supportées |

## Champs Optionnels Importants

| Champ | Type | Description |
|-------|------|-------------|
| `description` | `string` | Description du système |
| `authors` | `array` | Liste des auteurs avec `name`, `url`, `email`, `discord` |
| `url` | `string` | URL du projet (GitHub, site web) |
| `manifest` | `string` | URL vers le manifeste pour les mises à jour automatiques |
| `download` | `string` | URL de téléchargement du zip |
| `license` | `string` | Licence ou URL vers le fichier de licence |
| `readme` | `string` | URL vers le README |
| `bugs` | `string` | URL pour signaler des bugs |
| `changelog` | `string` | URL vers le changelog |

## Section `compatibility`

```json
{
  "compatibility": {
    "minimum": "13.347",     // Version minimale REQUISE
    "verified": "13",        // Version TESTÉE (affichage vert)
    "maximum": "13"          // Version maximale supportée (optionnel)
  }
}
```

- **`minimum`** : Le système ne se chargera pas si la version est inférieure
- **`verified`** : Affiche un indicateur vert dans le setup
- **`maximum`** : Empêche le chargement sur des versions plus récentes (rare)

## Section `documentTypes` (v11+)

C'est ici que vous déclarez les **sous-types** de documents supportés par votre système.

### Syntaxe Complète

```json
{
  "documentTypes": {
    "Actor": {
      "character": {
        "htmlFields": ["details.biography.value", "details.biography.public"]
      },
      "npc": {
        "htmlFields": ["details.biography.value"]
      },
      "vehicle": {
        "htmlFields": ["details.biography.value"]
      },
      "group": {
        "htmlFields": ["description.full", "description.summary"]
      }
    },
    "Item": {
      "weapon": {
        "filePathFields": {
          "activities.*.img": ["IMAGE"]
        },
        "htmlFields": ["description.value", "description.chat"]
      },
      "spell": {
        "htmlFields": ["description.value", "description.chat"]
      },
      "class": {
        "filePathFields": {
          "advancement.*.icon": ["IMAGE"]
        },
        "htmlFields": ["description.value"]
      },
      "feat": {
        "htmlFields": ["description.value", "description.chat"]
      }
    },
    "ActiveEffect": {
      "enchantment": {}
    },
    "ChatMessage": {
      "request": {},
      "roll": {},
      "turn": {}
    },
    "JournalEntryPage": {
      "class": {
        "htmlFields": ["details.value"]
      },
      "map": {},
      "rule": {
        "htmlFields": ["tooltip"]
      }
    },
    "RegionBehavior": {
      "dnd5e.difficultTerrain": {},
      "dnd5e.rotateArea": {}
    }
  }
}
```

### Options par Type

| Option | Type | Description |
|--------|------|-------------|
| `htmlFields` | `string[]` | Chemins des champs contenant du HTML enrichi (pour la sécurité et l'enrichissement) |
| `filePathFields` | `object` | Chemins des champs contenant des chemins de fichiers, avec les catégories autorisées |

### Types de Documents Supportés

- `Actor` - Personnages, PNJ, créatures
- `Item` - Objets, sorts, capacités
- `ActiveEffect` - Effets actifs
- `ChatMessage` - Messages de chat
- `JournalEntryPage` - Pages de journal
- `RegionBehavior` - Comportements de région (zones sur le canvas)

### Exemple : Déclarer des Types d'Actor

Pour un système avec 3 types d'acteurs : `character`, `monster`, `vehicle` :

```json
{
  "documentTypes": {
    "Actor": {
      "character": {
        "htmlFields": ["biography"]
      },
      "monster": {
        "htmlFields": ["biography", "lore"]
      },
      "vehicle": {
        "htmlFields": ["description"]
      }
    }
  }
}
```

Ces types seront ensuite associés à des DataModels dans votre code :

```javascript
// Dans module/data/actor/_module.mjs
export const config = {
  character: CharacterData,
  monster: MonsterData,
  vehicle: VehicleData
};

// Enregistrement dans le hook init
CONFIG.Actor.dataModels = config;
```

## Section `packs` (Compendiums)

Les compendiums sont des collections de documents préchargées.

### Syntaxe

```json
{
  "packs": [
    {
      "name": "monsters",                    // Identifiant unique
      "label": "Monsters (SRD)",             // Nom affiché
      "system": "dnd5e",                     // ID du système
      "path": "packs/monsters",              // Chemin vers les données
      "type": "Actor",                       // Type de document
      "private": false,                      // Visible par défaut ?
      "ownership": {                         // Permissions par défaut
        "PLAYER": "OBSERVER",
        "ASSISTANT": "OWNER"
      },
      "flags": {
        "dnd5e": {
          "sourceBook": "SRD 5.1",
          "types": ["npc"]                   // Sous-types contenus
        }
      }
    },
    {
      "name": "spells",
      "label": "Spells (SRD)",
      "path": "packs/spells",
      "type": "Item",
      "flags": {
        "dnd5e": {
          "sorting": "m",                    // Mode de tri manuel
          "types": ["spell"]
        }
      }
    }
  ]
}
```

### Champs de Pack

| Champ | Type | Description |
|-------|------|-------------|
| `name` | `string` | Identifiant unique du pack |
| `label` | `string` | Nom affiché dans l'interface |
| `path` | `string` | Chemin relatif vers le dossier des données |
| `type` | `string` | Type de document : `Actor`, `Item`, `JournalEntry`, `RollTable`, `Scene`, `Macro`, `Playlist` |
| `system` | `string` | ID du système propriétaire |
| `private` | `boolean` | Si `true`, masqué par défaut |
| `ownership` | `object` | Permissions par rôle |
| `flags` | `object` | Données personnalisées |

### Types de Packs Supportés

- `Actor` - Personnages, monstres
- `Item` - Objets, sorts, capacités
- `JournalEntry` - Entrées de journal
- `RollTable` - Tables aléatoires
- `Scene` - Scènes
- `Macro` - Macros
- `Playlist` - Playlists audio
- `Adventure` - Aventures complètes

## Section `packFolders`

Organise les compendiums en dossiers dans l'interface.

```json
{
  "packFolders": [
    {
      "name": "D&D Modern Content",
      "color": "#cd2c1e",
      "sorting": "m",                        // m = manuel, a = alphabétique
      "packs": [
        "classes24",
        "spells24",
        "equipment24"
      ]
    },
    {
      "name": "D&D Legacy Content",
      "color": "#cd2c1e",
      "packs": ["rules", "tables"],
      "folders": [                           // Sous-dossiers
        {
          "name": "Character Features",
          "color": "#b72c1f",
          "packs": ["classes", "backgrounds", "races"]
        },
        {
          "name": "Monsters",
          "color": "#7d160c",
          "packs": ["monsters", "monsterfeatures"]
        }
      ]
    }
  ]
}
```

## Section `languages`

Fichiers de traduction disponibles.

```json
{
  "languages": [
    {
      "lang": "en",
      "name": "English",
      "path": "lang/en.json",
      "flags": {}
    },
    {
      "lang": "fr",
      "name": "Français",
      "path": "lang/fr.json"
    }
  ]
}
```

## Autres Sections Importantes

### `grid` - Configuration par défaut de la grille

```json
{
  "grid": {
    "distance": 5,       // Distance par case
    "units": "ft"        // Unité de mesure
  }
}
```

### `primaryTokenAttribute` - Barre principale des tokens

```json
{
  "primaryTokenAttribute": "attributes.hp"
}
```

### `socket` - Communication WebSocket

```json
{
  "socket": true         // Active game.socket.emit pour ce système
}
```

### `background` - Image de fond du setup

```json
{
  "background": "systems/dnd5e/ui/official/dnd5e-background.webp"
}
```

### `media` - Médias pour le marketplace

```json
{
  "media": [
    {
      "type": "cover",
      "loop": false
    },
    {
      "type": "setup",
      "url": "systems/dnd5e/ui/official/dnd5e-repo.jpg",
      "thumbnail": "systems/dnd5e/ui/official/dnd5e-thumbnail.jpg"
    }
  ]
}
```

### `flags` - Données personnalisées du système

```json
{
  "flags": {
    "needsMigrationVersion": "5.2.0",
    "compatibleMigrationVersion": "0.8",
    "hotReload": {
      "extensions": ["css", "hbs", "json"],
      "paths": ["dnd5e.css", "templates", "lang"]
    }
  }
}
```

## Manifeste Minimal

Voici le manifeste minimum pour un système fonctionnel :

```json
{
  "id": "mon-systeme",
  "title": "Mon Système de JDR",
  "version": "1.0.0",
  "compatibility": {
    "minimum": "13",
    "verified": "13"
  },
  "esmodules": ["main.mjs"],
  "styles": ["styles.css"],
  "documentTypes": {
    "Actor": {
      "character": {}
    },
    "Item": {
      "item": {}
    }
  },
  "languages": [
    {
      "lang": "en",
      "name": "English",
      "path": "lang/en.json"
    }
  ]
}
```

## Validation du Manifeste

FoundryVTT valide le manifeste au chargement. Erreurs courantes :

1. **ID invalide** : Doit correspondre au nom du dossier
2. **Version manquante** : Le champ `version` est obligatoire
3. **Compatibility manquante** : `minimum` doit être défini
4. **Chemins inexistants** : Les fichiers référencés doivent exister
5. **Types non enregistrés** : Les types dans `documentTypes` doivent avoir un DataModel associé

## Liens vers la Documentation Officielle

- [Package Manifest](https://foundryvtt.com/article/system-development/#manifest)
- [Document Types](https://foundryvtt.wiki/en/development/api/document)
- [Compendium Packs](https://foundryvtt.com/article/compendium/)

---

*Documentation suivante : [02-datamodels.md](./02-datamodels.md) - DataModels et TypeDataModel*
