# Index - Documentation Règles et Processus Métier

**Documentation pour le développement d'un système FoundryVTT v13**  
**Basée sur l'analyse critique du système dnd5e 5.2.0**

---

## Vue d'ensemble

Cette documentation rassemble les bonnes pratiques, anti-patterns et règles métier pour développer un système FoundryVTT v13 de qualité. Elle est issue d'une analyse approfondie du système dnd5e officiel.

---

## Documents Disponibles

### 1. Analyse Critique du Système dnd5e
📄 **[analyse-critique-dnd5e.md](./analyse-critique-dnd5e.md)**

Analyse complète du système dnd5e 5.2.0 avec :
- Points forts à reproduire (architecture modulaire, configuration, pré-localisation, etc.)
- Points faibles à éviter (fichiers monolithiques, couplage fort, etc.)
- Dette technique identifiée
- Recommandations pour un nouveau système v13

> **Public cible** : Développeurs qui veulent comprendre les choix de dnd5e avant de créer leur propre système.

---

### 2. Bonnes Pratiques pour FoundryVTT v13
📄 **[bonnes-pratiques.md](./bonnes-pratiques.md)**

Guide complet des patterns recommandés :
- Architecture et organisation du code
- Utilisation d'ApplicationV2 et DataModel
- Internationalisation (i18n) et pré-localisation
- Enrichers de texte personnalisés
- Système de migrations
- Registres et gestion des relations
- Performance et accessibilité
- Tests et qualité

> **Public cible** : Développeurs qui démarrent un nouveau système et veulent suivre les meilleures pratiques.

---

### 3. Anti-Patterns à Éviter
📄 **[anti-patterns.md](./anti-patterns.md)**

Catalogue des erreurs courantes avec :
- Code à NE PAS copier de dnd5e (avec justification)
- Exemples concrets : code à éviter vs code recommandé
- Impacts de chaque anti-pattern
- Checklist de vérification

> **Public cible** : Développeurs qui veulent éviter les pièges courants et la dette technique.

---

## Organisation de la Documentation

```
docs/
├── rules/                          # Documentation règles et processus
│   ├── index.md                    # Ce fichier
│   ├── analyse-critique-dnd5e.md   # Analyse du système de référence
│   ├── bonnes-pratiques.md         # Patterns recommandés
│   └── anti-patterns.md            # Patterns à éviter
│
└── tech/                           # Documentation technique (9 fichiers)
    ├── index.md                    # Index de la section tech
    ├── 00-overview.md              # Vue d'ensemble architecture
    ├── 01-system-json.md           # Manifeste system.json
    ├── 02-datamodels.md            # DataModels et TypeDataModel
    ├── 03-documents.md             # Documents et Extensions
    ├── 04-applications-sheets.md   # ApplicationV2 et Sheets
    ├── 05-hooks.md                 # Système de Hooks
    ├── 06-dice.md                  # Système de Dés
    └── 07-canvas.md                # Canvas et Interactions Visuelles
```

---

## Ordre de Lecture Recommandé

### 🚀 Parcours Découverte (débutant)
1. **[docs/tech/00-overview.md](../tech/00-overview.md)** - Comprendre l'architecture d'un système FoundryVTT
2. **[docs/tech/01-system-json.md](../tech/01-system-json.md)** - Configurer le manifeste system.json
3. **[analyse-critique-dnd5e.md](./analyse-critique-dnd5e.md)** - Analyser le système de référence
4. **[bonnes-pratiques.md](./bonnes-pratiques.md)** - Apprendre les patterns modernes
5. **[anti-patterns.md](./anti-patterns.md)** - Éviter les erreurs courantes

### 📚 Parcours Approfondi (intermédiaire)
6. **[docs/tech/02-datamodels.md](../tech/02-datamodels.md)** - Maîtriser les DataModels
7. **[docs/tech/03-documents.md](../tech/03-documents.md)** - Comprendre les Documents et Extensions
8. **[docs/tech/04-applications-sheets.md](../tech/04-applications-sheets.md)** - Créer des interfaces avec ApplicationV2

### 🎯 Parcours Avancé (expert)
9. **[docs/tech/05-hooks.md](../tech/05-hooks.md)** - Maîtriser le système de Hooks
10. **[docs/tech/06-dice.md](../tech/06-dice.md)** - Implémenter un système de dés
11. **[docs/tech/07-canvas.md](../tech/07-canvas.md)** - Manipuler le Canvas et les interactions visuelles

> 📖 **Index technique complet** : [docs/tech/index.md](../tech/index.md)

---

## Quick Reference

### Patterns Essentiels

| Domaine | Pattern Recommandé | Anti-Pattern |
|---------|-------------------|--------------|
| Structure | Fichiers < 300 lignes | Fichiers monolithiques 2000+ lignes |
| Config | Découpée par domaine | Un seul fichier config.mjs |
| UI | ApplicationV2 | Application v1 (dépréciée) |
| Données | DataModel + validation | Objets sans schéma |
| IDs | Lookup par identifiant métier | UUIDs hardcodés |
| Règles | Version unique | Conditions multi-versions partout |

### Hooks Essentiels

```javascript
Hooks.once("init", function() {
  // Configuration initiale, enregistrement des classes
});

Hooks.once("i18nInit", () => {
  // Pré-localisation des configs
});

Hooks.once("setup", function() {
  // Configuration post-modules
});

Hooks.once("ready", function() {
  // Migrations et initialisation finale
});
```

---

## Ressources Externes

- [API FoundryVTT v13](https://foundryvtt.com/api/)
- [Discord Foundry - Canal Development](https://discord.gg/foundryvtt)
- [GitHub dnd5e](https://github.com/foundryvtt/dnd5e)
- [System Development Wiki](https://foundryvtt.wiki/en/development/guides/SD-tutorial/SD01-Getting-started)

---

## Changelog

| Date | Modification |
|------|--------------|
| 2026-01-05 | Création initiale de la documentation |
| 2026-01-05 | Ajout liens vers documentation technique complète (01 à 07) |

